/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.io;

import edu.umd.cs.findbugs.annotations.DischargesObligation;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truecommons.io.DecoratingOutputStream;

@ThreadSafe
public class LockOutputStream
extends DecoratingOutputStream {
    private final Lock lock;

    protected LockOutputStream(Lock lock) {
        this.lock = Objects.requireNonNull(lock);
    }

    public LockOutputStream(Lock lock, @WillCloseWhenClosed OutputStream out) {
        this(lock);
        this.out = Objects.requireNonNull(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="lock")
    public void write(int b) throws IOException {
        this.lock.lock();
        try {
            this.out.write(b);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="lock")
    public void write(byte[] b, int off, int len) throws IOException {
        this.lock.lock();
        try {
            this.out.write(b, off, len);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="lock")
    public void flush() throws IOException {
        this.lock.lock();
        try {
            this.out.flush();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @DischargesObligation
    @GuardedBy(value="lock")
    public void close() throws IOException {
        this.lock.lock();
        try {
            this.out.close();
        }
        finally {
            this.lock.unlock();
        }
    }
}

